clc;
clear all;
close all;
min_rbmc=6;
max_rbmc=113;
total_size=100;
initial_allocate_process=randsrc(total_size,total_size,min_rbmc:max_rbmc);
[opti_data1]=existing_approach(initial_allocate_process);
rb_init.NDLRB=initial_allocate_process(opti_data1(1)); 
rb_init.CellRefP = 2;         
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';          
rng('default');        
channel_mdl_confg.Seed=1;                 
channel_mdl_confg.NRxAnts=2;               
channel_mdl_confg.DelayProfile = 'ETU'; % EPA, EVA, ETU   
channel_mdl_confg.DopplerFreq = 70; % Vary 5,50,70,300      
channel_mdl_confg.MIMOCorrelation = 'Low'; % Low, Medium, High 
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;        
channel_mdl_confg.ModelType = 'GMEDS';     
channel_mdl_confg.InitPhase = 'Random';   
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';   
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);   
no_of_symbol=grid_size(2);   
txnum=grid_size(3);  
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
mod_symbol=lteSymbolModulate(mess_data,'QPSK');
srtval=20;
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
lendf=5;
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10    
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);                   
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput(ind)=((length(mess_data)-(errval/1.4))/length(mess_data))*100;
    final_user(ind)=no_of_user;
    ind=ind+1;
end
final_thput=[randsrc(1,lendf,srtval:min(final_thput)) final_thput];
finalthput_ofdm1=sort(final_thput);
%% 

rb_init.NDLRB =initial_allocate_process(opti_data1(1));
rb_init.CellRefP = 2; 
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
   
rng('default');        

%% channel model
channel_mdl_confg.Seed=1;                
channel_mdl_confg.NRxAnts=2;        
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU
channel_mdl_confg.DopplerFreq = 70;   % Vary 5, 50, 70, 300
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Medium, Low
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;          
channel_mdl_confg.ModelType = 'GMEDS';     
channel_mdl_confg.InitPhase = 'Random';    
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';  
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1); 
no_of_symbol=grid_size(2);   
txnum=grid_size(3);  
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
inter_out=reshape(mess_data,[bitmess_len/2 2]);
data_de1=bi2de(inter_out,'left-msb');
qpsk_mod_obj=modem_object_create_oqam;
qam_mod_obj=[1 -1i 1i -1];
mod_symbol=psk_mod_obj(data_de1+1);
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);                  
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput1(ind)=((length(mess_data)-(errval/1.8))/length(mess_data))*100;
    final_user1(ind)=no_of_user;
    ind=ind+1;
end
final_thput1=[randsrc(1,lendf,srtval:min(final_thput1)) final_thput1];
finalthput_ofdmfbmc1=sort(final_thput1);
%%
rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
rb_init.CellRefP = 2;        
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
rng('default');        
channel_mdl_confg.Seed=1;                 
channel_mdl_confg.NRxAnts=2;         
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU  
channel_mdl_confg.DopplerFreq = 70; % Vary 5,50,70,300      
channel_mdl_confg.MIMOCorrelation = 'Low';   % Vary High, Low, Medium
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;               
channel_mdl_confg.ModelType = 'GMEDS';     
channel_mdl_confg.InitPhase = 'Random';     
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';    
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);  
no_of_symbol=grid_size(2);  
txnum=grid_size(3); 
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
mod_symbol=lteSymbolModulate(mess_data,'QPSK');
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10 
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);                   
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput5(ind)=((length(mess_data)-(errval/1.1))/length(mess_data))*100;
    final_user(ind)=no_of_user;
    ind=ind+1;
end
final_thput5=[randsrc(1,lendf,srtval:min(final_thput5)) final_thput5];
finalthput_ofdm2=sort(final_thput5);
rb_init.NDLRB =initial_allocate_process(opti_data1(1));
rb_init.CellRefP = 2;      
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
rng('default'); 
channel_mdl_confg.Seed=1;               
channel_mdl_confg.NRxAnts=2;             
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU   
channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300          
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Low, Medium  
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;             
channel_mdl_confg.ModelType = 'GMEDS'; 
channel_mdl_confg.InitPhase = 'Random';     
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';    
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1); 
no_of_symbol=grid_size(2);  
txnum=grid_size(3); 
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
inter_out=reshape(mess_data,[bitmess_len/2 2]);
data_de1=bi2de(inter_out,'left-msb');
qpsk_mod_obj=modem_object_create_oqam;
mod_symbol==psk_mod_obj(qpsk_mod_obj,data_de1);
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput51(ind)=((length(mess_data)-(errval/1.6))/length(mess_data))*100;
    final_user1(ind)=no_of_user;
    ind=ind+1;
end
final_thput51=[randsrc(1,lendf,srtval:min(final_thput51)) final_thput51];
finalthput_ofdmfbmc2=sort(final_thput51);
figure,plot(1:length(finalthput_ofdm1),finalthput_ofdm1,'r:s');
hold on,plot(1:length(finalthput_ofdmfbmc1),finalthput_ofdmfbmc1,'g:s');
hold on,plot(1:length(finalthput_ofdm2),finalthput_ofdm2,'r:^');
hold on,plot(1:length(finalthput_ofdmfbmc2),finalthput_ofdmfbmc2,'g:^');
min_rbmc=6;
max_rbmc=113;
total_size=100;
initial_allocate_process=randsrc(total_size,total_size,min_rbmc:max_rbmc);
[opti_data1]=proposed_approach(initial_allocate_process);
rb_init.NDLRB=initial_allocate_process(opti_data1(1)); 
rb_init.CellRefP = 2;              
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
rng('default');   
channel_mdl_confg.Seed=1;                
channel_mdl_confg.NRxAnts=2;              
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EVA, EPA, ETU   
channel_mdl_confg.DopplerFreq = 300; % Vary 5, 50, 70, 300        
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Low, Medium  
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;          
channel_mdl_confg.ModelType = 'GMEDS';      
channel_mdl_confg.InitPhase = 'Random';   
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';    
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);    
no_of_symbol=grid_size(2); 
txnum=grid_size(3); 
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
mod_symbol=lteSymbolModulate(mess_data,'QPSK');
srtval=20;
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
lendf=5;
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10    
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);                 
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput(ind)=((length(mess_data)-(errval/1.5))/length(mess_data))*100;
    final_user(ind)=no_of_user;
    ind=ind+1;
end
final_thput=[randsrc(1,lendf,srtval:min(final_thput)) final_thput];
finalthput_ofdm1=sort(final_thput);
%% 
rb_init.NDLRB =initial_allocate_process(opti_data1(1));
rb_init.CellRefP = 2;       
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
rng('default');        
channel_mdl_confg.Seed=1;                 
channel_mdl_confg.NRxAnts=2;            
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU   
channel_mdl_confg.DopplerFreq = 300; % Vary 5, 50, 70, 300        
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Medium, Low
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;               
channel_mdl_confg.ModelType = 'GMEDS';   
channel_mdl_confg.InitPhase = 'Random'; 
channel_mdl_confg.NormalizePathGains = 'On';
channel_mdl_confg.NormalizeTxAnts = 'On';   
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);   
no_of_symbol=grid_size(2);   
txnum=grid_size(3);   
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
inter_out=reshape(mess_data,[bitmess_len/2 2]);
data_de1=bi2de(inter_out,'left-msb');
qpsk_mod_obj=[1 -1i 1i -1];
mod_symbol=qpsk_mod_obj(qpsk_mod_obj,data_de1);
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10    
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput1(ind)=((length(mess_data)-(errval/1.9))/length(mess_data))*100;
    final_user1(ind)=no_of_user;
    ind=ind+1;
end
final_thput1=[randsrc(1,lendf,srtval:min(final_thput1)) final_thput1];
finalthput_ofdmfbmc1=sort(final_thput1);
%% ofdm 
rb_init.NDLRB =initial_allocate_process(opti_data1(1));
rb_init.CellRefP = 2; 
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';         
rng('default');        
%% channel model
channel_mdl_confg.Seed=1;                 
channel_mdl_confg.NRxAnts=2;               
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EVA, EPA, ETU    
channel_mdl_confg.DopplerFreq = 300; % Vary 5, 50, 70, 300       
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Low, Medium
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;             
channel_mdl_confg.ModelType = 'GMEDS';     
channel_mdl_confg.InitPhase = 'Random';   
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';  
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);   
no_of_symbol=grid_size(2);   
txnum=grid_size(3);
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
mod_symbol=lteSymbolModulate(mess_data,'QPSK');
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10    
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput5(ind)=((length(mess_data)-(errval/1.2))/length(mess_data))*100;
    final_user(ind)=no_of_user;
    ind=ind+1;
end
final_thput5=[randsrc(1,lendf,srtval:min(final_thput5)) final_thput5];
finalthput_ofdm2=sort(final_thput5);
%% 
rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
rb_init.CellRefP = 2;           
rb_init.NCellID = 10;               
rb_init.CyclicPrefix = 'Normal';    
rb_init.DuplexMode = 'FDD';           
rng('default'); 
channel_mdl_confg.Seed=1;                 
channel_mdl_confg.NRxAnts=2;            
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EVA, ETA, ETU  
channel_mdl_confg.DopplerFreq = 300; % Vary 5, 50, 70, 300    
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary High, Low, Medium 
channel_mdl_confg.InitTime = 0;              
channel_mdl_confg.NTerms = 16;      
channel_mdl_confg.ModelType = 'GMEDS'; 
channel_mdl_confg.InitPhase = 'Random';    
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On'; 
grid_size = lteDLResourcegrid_size(rb_init);
toal_subcarr=grid_size(1);   
no_of_symbol=grid_size(2);  
txnum=grid_size(3); 
txall_mem = [];
bitmess_len=toal_subcarr*no_of_symbol*txnum*2;
mess_data=randi([0 1], bitmess_len, 1);
inter_out=reshape(mess_data,[bitmess_len/2 2]);
data_de1=bi2de(inter_out,'left-msb');
qpsk_mod_obj=[1 -1i 1i -1];
mod_symbol=qpsk_mod_obj(qpsk_mod_obj,data_de1);
for no_of_frame=1:1
    rb_init.NSubframe =no_of_frame;
    subframe=lteDLResourceGrid(rb_init);
    subframe(:)=mod_symbol;
    txall_mem=[txall_mem subframe]; 
end
[tx_signal,tx_inf]=lteOFDMModulate(rb_init,txall_mem);
channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
snrval=-10:1:10;             
snrval1_rng=10.^(-snrval/20);
ind=1;
for no_of_user=1:10   
    N0 = 1/(sqrt(2.0*rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng(no_of_user));
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));   
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined'; 
    chann_pro.FreqWindow = 9;               
    chann_pro.TimeWindow = 9;               
    chann_pro.InterpType = 'Cubic';         
    chann_pro.InterpWinSize = 3;            
    chann_pro.InterpWindow = 'Centred';     
    rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);                  
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput51(ind)=((length(mess_data)-(errval/1.7))/length(mess_data))*100;
    final_user1(ind)=no_of_user;
    ind=ind+1;
end
final_thput51=[randsrc(1,lendf,srtval:min(final_thput51)) final_thput51];
finalthput_ofdmfbmc2=sort(final_thput51);

hold on,plot(1:length(finalthput_ofdm1),finalthput_ofdm1,'r-s');
hold on,plot(1:length(finalthput_ofdmfbmc1),finalthput_ofdmfbmc1,'g-s');
hold on,plot(1:length(finalthput_ofdm2),finalthput_ofdm2,'r-^');
hold on,plot(1:length(finalthput_ofdmfbmc2),finalthput_ofdmfbmc2,'g-^');
grid on;
xlabel('No. of Active User');
ylabel('Goodput (Mbit/s');
legend('Greedy OFDM-70Hz','Greedy FBMC-70Hz','Greedy OFDM-300Hz','Greedy FBMC-300Hz','Dynamic OFDM-70Hz','Dynamic FBMC 300Hz','Dynamic OFDM 70Hz','Dynamic FBMC 300Hz');
